<?xml version="1.0"?>
<xsl:stylesheet>
<xsl:output method="html" indent="no"/>
<xsl:include href="movieCommon.xsl"/>

<!-- Parameters for assigning a unique names to the graphical elements
	on the page. These can be set from Java in XSLTProcessor object.
-->
<xsl:param name="movieNum" select="'default'"/>
<xsl:param name="aveRating" select="'2.5'"/>
<xsl:param name="movieArtRoot" select="'cover_art'"/>
<xsl:param name="productPage" select="'default'"/>
<xsl:param name="itemIDParam" select="'default'"/>
<xsl:param name="itemID"  select="'default'"/>
<xsl:param name="predRatingParam" select="'default'"/>
<xsl:param name="predRating" select="'defualt'"/>
<xsl:param name="dateAdded" select ="'default'"/>
<xsl:param name="deleteParam" select="'default'"/>
	

<xsl:template name="productURL">
	<xsl:value-of select="$productPage"/>?<xsl:value-of select="$itemIDParam"/>=<xsl:value-of select="$itemID"/>&amp;<xsl:value-of select="$predRatingParam"/>=<xsl:value-of select="$predRating"/>
</xsl:template>

<!--	Template for document root. Prevents the regurgitation of bad XML
-->
<xsl:template match="/">
    <td bgcolor="#FFFFFF" valign="top" width="197"> <!--Start movie ratings table  w=192--> 
		<xsl:apply-templates select="MOVIE"/>
	</td>
</xsl:template>

<!-- Template for the movie: outputs a single table element
	(<td>) for inclusion in a table of movie recommendations.
-->
<xsl:template match="/MOVIE">
	<!-- Store product URL in parameter for fater multiple access.-->
	<xsl:param name="prodURL">
		<xsl:call-template name="productURL"/>	
	</xsl:param>
                <table align="center" border="0" cellspacing="0" cellpadding="0" width="192">
                <tr> 
                  <td width="192" valign="top"><font face="Arial, Helvetica, sans-serif" size="2">
					<a><xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute>
					<b>	<xsl:value-of select="TITLES/TITLES_ITEM/TITLE"/> (<xsl:value-of select="ORIGRELEASEYEAR"/>) <xsl:value-of select="RELEASES/RELEASES_ITEM/RATINGTEXT"/>
					</b></a></font>
					<!--Start ratings  table w=190-->
                    <table width="190" border="0" cellspacing="0" cellpadding="0">
                      <tr valign="top"> 
                        <td width="63"><img src="images/seenitrateit.gif" width="62" height="51" /></td>
                        <td width="127" valign="top" align="left">
						<!--Start iguys table w=126-->
                          <table width="126" border="0" cellspacing="0" cellpadding="0">
                            <tr valign="top" align="left"> 
								<!-- rating title -->
                              <td height="13" width="126"> 	
							  	<img src="images/spacer.gif" width="126" height="13" border="0" alt="">
										<xsl:attribute name="name">title<xsl:value-of select="$movieNum"/></xsl:attribute>
								</img>
							  </td>
                            </tr>
                            <tr valign="top" align="left"> 
								<!-- rating 'iguy' image -->
								<td height="21" width="126"> 
									<img src="images/iguy_null.gif" width="95" height="21" border="0" alt="iiiiii" >
										<xsl:attribute name="name">iguy<xsl:value-of select="$movieNum"/></xsl:attribute>
										<xsl:attribute name="usemap">#predicted<xsl:value-of select="$movieNum"/></xsl:attribute>
									</img>
								</td>
                            </tr>
							 <tr valign="top" align="left"> 
									<!-- line image for predicted rating -->
									<td height="4" width="126">
										<img src="images/spacer.gif" width="95" height="6" border="0" alt="">
											<xsl:attribute name="name">line<xsl:value-of select="$movieNum"/></xsl:attribute>
										</img>
									</td>
							</tr>
	   						<!-- interest buttons -->
							<tr valign="top"> 
								<td colspan="2" height="29">
<!--								<b id="normaltext">Want to see it?<br/>&#160;-->
										<img name="button" src="images/want_null.gif" width="0" height="0" border="0" alt="want">
											<xsl:attribute name="name">button<xsl:value-of select="$movieNum"/></xsl:attribute>
											<xsl:attribute name="usemap">#radiobutton<xsl:value-of select="$movieNum"/></xsl:attribute>
										</img>
<!--									</b>-->
								</td>
							</tr>
						  </table>
							  <!--End iguys table w=126-->
							</td>
						  </tr>
                      <tr valign="top"> 
                        <td colspan="2" height="9">
							<font face="Arial, Helvetica, sans-serif" size="1"><!--<b>Average Rating: <xsl:value-of select="$aveRating"/></b><br/>-->
							  Date Added to My List: <xsl:value-of select="$dateAdded"/></font>
						</td>
                      </tr>
                    </table>
                    <!--End ratings  table w=190-->
				  </td>
                </tr>
			<tr>
		    <td colspan="2" bgcolor="#FFFFFF" valign="top"><span id="smalltext">Check to Delete<input type="checkbox" value="1">
				  	<xsl:attribute name="name"><xsl:value-of select="$deleteParam"/></xsl:attribute>
				  	<xsl:attribute name="value"><xsl:value-of select="$itemID"/></xsl:attribute>
				</input></span>
			</td>
			</tr>				
            </table>
              <!--End movie ratings table  w=192--><br/>

</xsl:template>

</xsl:stylesheet>


